/***************************************************************************
 *	Sistemas Operacionais 1
 *	Experimento #4
 *	
 *	Pontificia Universidade Catolica - Campinas - SP - Brasil
 *	http://www.puc-campinas.edu.br
 *
 *	Prof. Carlos Miguel Tobar -  tobar@puc-campinas.edu.br 
 *	
 *	Programadores :: Turma 3 - Grupo 8
 *	Cesar Kallas	cesarkallas@gmx.net		RA: 02099224
 *	Bruno Mazzoco	brunomazzoco@yahoo.com.br	RA: 02150522 
 *
 * 16/04/2004
 *
 * Este experimento visa medir o tempo gasto de processamento
 * que leva a CPU para impedir o acesso a determinado recurso e
 * posteriormente liberar o acesso usando semafaro.
 * (Trancar e destrancar um semafaro).
 */
 
#include <errno.h>              /* errno and error codes */
#include <sys/time.h>           /* for gettimeofday() */
#include <stdio.h>              /* for printf() */
#include <sys/types.h>          /* for wait() */
#include <sys/wait.h>           /* for wait() */
#include <signal.h>             /* for kill(), sigsuspend(), others */
#include <sys/ipc.h>            /* for all IPC function calls */
#include <sys/sem.h>            /* for semget(), semop(), semctl() */


#define NUMERO_DE_SEM 1
#define CHAVE_DE_SEM 0x1234
#define PERMISSAO_SEM 0666
#define MICRO_PER_SECOND 1000000
#define NUMERO_DE_TESTES 500

int main(int argc, char *argv)
{
	float tempo_diferenca=0.0, tempo_maximo=0.0, tempo_total=0.0;
	int i=0;
	
	/*
	 * Estrtura para armazenar o tempo medido
	 */
	struct timeval tempo_abrir;
	struct timeval tempo_fechar;
	
	/* 
	* Numero da identificao do semapharo
	*/
	int id;
	
	struct sembuf sembuf_abrir[1];
	struct sembuf sembuf_fechar[1];
	
	/*
	 * Destrancar semapharo
	 */
	sembuf_abrir[0].sem_op = 1;
	sembuf_abrir[0].sem_num = 0;		/* numero do semapharo */
	sembuf_abrir[0].sem_flg = 0;
	
	sembuf_fechar[0].sem_op = -1;
	sembuf_fechar[0].sem_num = 0;		/* numero do semapharo */
	sembuf_fechar[0].sem_flg = 0;
	
	/*
	 * Criacao do semapharo
	*/
	if( (id = semget(CHAVE_DE_SEM, 1, IPC_CREAT |0666 )) == -1 )
	{
		perror("\n Erro na requisicao de criacao do semapharo - semget \n");
		fprintf(stderr,"Erro na requisicao de criacao do semapharo - semget");
		exit(1);
	}
	
	if( semop(id, sembuf_abrir, 1) == -1)
	{
		fprintf(stderr,"");
		perror("\n Erro ao usar o semapharo na chamada semop\n");
		exit(1);
	}
	
	
	for(i=0; i<NUMERO_DE_TESTES; i++)
	{
		/* Tempo inicial, para abrir o semafaro */
		gettimeofday(&tempo_abrir, NULL);
			
		/* Fizemos varios testes, usando o IF na chamada do semop
		 * e sem o IF, porem foi constatado que a diferenca nao eh visivel
		 * e como o IF pode ser benefico para possiveis erro, ele foi mantido
		 */
		if( semop(id, sembuf_fechar, 1) == -1 )
		{
			perror("\nImpossivel fechar semafaro\n");
			printf("\nImpossivel fechar semafaro\n");
			exit(1);
		}
		
		if( semop(id, sembuf_abrir, 1) == -1 )
		{
			perror("\nImpossivel abrir semafaro\n");
			printf("\nImpossivel abrir semafaro\n");
			exit(1);
		}
		
		/* Tempo atual, depois de fechar o semafaro */
		gettimeofday(&tempo_fechar, NULL);
		
		/* Calcula a diferenca entre o tempo inicial e final */
		tempo_diferenca  = ( tempo_fechar.tv_sec  - tempo_abrir.tv_sec );
		tempo_diferenca += ( tempo_fechar.tv_usec - tempo_abrir.tv_usec )/(float)MICRO_PER_SECOND;
		tempo_total += tempo_diferenca;
		
		/*
		 * Salva o tempo maximo
		 */
		if(tempo_diferenca > tempo_maximo)
			tempo_maximo = tempo_diferenca;
	}

	/*
	 * Removendo o semaforo
	 */
	if( semctl( id, 0, IPC_RMID, 0) != 0 ) {
		fprintf(stderr,"Impossivel remover o semaforo!\n");
		exit(1);
	}
	
	/*
	 * Resultados
	 */
	printf("\n\n===== Tempos para Abrir e Fechar Semafaros ======\n\n");
	printf("\tO tempo medio : %.12f s\n", tempo_total / NUMERO_DE_TESTES);
	printf("\tO tempo maximo: %.12f s\n\n", tempo_maximo);
	
	return 0;
}
