unit Editor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Buttons, ComCtrls, Menus, DBGrids, DBLookup;
const
     tam_pagina = 8;   // Nmero palavras de uma pgina
     num_instr = 15; // Nmero de instrues de Assembler implementadas em Hardware

     // Array de instrues
     INSTR: array[0..num_instr-1] of String =
     ('HLT', 'RD', 'PRN', 'LD', 'STR', 'SUB', 'ADD', 'JMP', 'JNG', 'SUI', 'ADI', 'MUL', 'DIV', 'LDI', 'STI');



type

 TPalavra = record
                c1, c2, c3: integer;
            end;


 TPagina = array[0..tam_pagina-1] of Tpalavra;
 TPPagina = ^TPagina;
 TF_Editor = class(TForm)
    MainMenu: TMainMenu;
    Job1: TMenuItem;
    BB_Novo: TMenuItem;
    BB_Abrir: TMenuItem;
    BB_Salvar: TMenuItem;
    BB_Sair: TMenuItem;
    Sobre1: TMenuItem;
    GroupBox: TGroupBox;
    PageControl: TPageControl;
    TabCod: TTabSheet;
    Label3: TLabel;
    LB_PagCod: TLabel;
    ST_Cod: TStringGrid;
    TabDados: TTabSheet;
    Label1: TLabel;
    LB_PagDados: TLabel;
    ST_Dados: TStringGrid;
    BB_Pgup: TBitBtn;
    BB_Pgdw: TBitBtn;
    BB_Apagar: TBitBtn;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    E_Identificador: TEdit;
    E_TPrevisto: TEdit;
    Label25: TLabel;
    Label26: TLabel;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ListCommand: TListBox;
    BB_Fechar: TMenuItem;
    CheckTXT: TCheckBox;
    GroupBox1: TGroupBox;
    procedure FormCreate(Sender: TObject);
    procedure BB_PgupClick(Sender: TObject);
    procedure BB_PgdwClick(Sender: TObject);
    procedure BB_SairClick(Sender: TObject);
    procedure BB_NovoClick(Sender: TObject);
    procedure ST_CodKeyPress(Sender: TObject; var Key: Char);
    procedure ST_DadosKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BB_ApagarClick(Sender: TObject);
    procedure BB_SalvarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ST_CodKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListCommandKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BB_AbrirClick(Sender: TObject);
    procedure E_IdentificadorKeyPress(Sender: TObject; var Key: Char);
    procedure BB_FecharClick(Sender: TObject);
    procedure Sobre1Click(Sender: TObject);
    procedure CheckTXTClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Estado_Botoes (Estado:boolean);

    procedure Atualiza_Pagina (Tipo:char; Lista:Tlist; Indice:word);
    procedure SGridToPagina_Cod(PPagina:TPPagina);
    procedure SGridToPagina_Dados(PPagina:TPPagina);
    procedure PaginaToSGrid_Cod(Pagina:TPPagina);
    procedure PaginaToSGrid_Dados(Pagina:TPPagina);
    procedure ClearGrid(Grid:TStringGrid);
    procedure Zera_Pagina(PPagina: TPPagina);
    procedure ClearList(Lista:TList);

    function get_instr_cod(nome:string):smallint;

    procedure Erro(mensagem:string);
  end;

var
  F_Editor: TF_Editor;

  // Listas de pginas de cdigo e dados
  Codigo, Dados:Tlist;

  // ndices das pginas de cdigo e dados atuais
  IDados, ICod:word;

  // Indica se as pginas de dados e cdigos visualizadas foram modificadas
  Modified_Cod, Modified_Dados:boolean;

implementation

uses Sobre;

{$R *.DFM}




procedure TF_Editor.FormCreate(Sender: TObject);
begin
     // Inicia as listas de pginas de cdigo e de dados
     Codigo := TList.Create;
     Dados := TList.Create;

     Estado_Botoes(False);
     BB_Salvar.Enabled:=False;
     BB_Fechar.Enabled:=False;
     ListCommand.Hide;

     // Define o tamanha dos StringGrids
     ST_Cod.RowCount:=tam_pagina;
     ST_Dados.RowCount:=tam_pagina;
     Randomize;
end;

procedure TF_Editor.Estado_Botoes(Estado: boolean);
var i:byte;
begin
     // Desabilita/ Habilita todos os botoes do formulrio
     for i:=0 to GroupBox.ControlCount-1 do
         TControl(GroupBox.Controls[i]).Enabled := Estado;
end;



procedure TF_Editor.BB_PgupClick(Sender: TObject);
begin
  if PageControl.ActivePage = TabCod then begin // Pgina de cdigo

        if ICod = 0 then exit;
        if Modified_Cod then // A pgina foi modificada
              Atualiza_Pagina('C', Codigo, ICod);

        // Aponta para a pgina anterior da lista
        Dec(ICod);
        LB_PagCod.Caption := Inttostr(ICod);

        // Copia pgina anterior para a StringGrid
        PaginaToSGrid_Cod(Codigo.Items[ICod]);
        // Atualiza
        Modified_Cod := False;
     end


     else begin// Tratamento de pgina de dados

        if IDados = 0 then exit;
        if Modified_Dados then // A pgina foi modificada
              Atualiza_Pagina('D', Dados, IDados);

        // Aponta para a pgina anterior da lista
        Dec(IDados);
        LB_PagDados.Caption := Inttostr(IDados);

        // Copia pgina anterior para a StringGrid
        PaginaToSGrid_Dados(Dados.Items[IDados]);
        // Atualiza
        Modified_Dados := False;
     end

end;



procedure TF_Editor.BB_PgdwClick(Sender: TObject);
begin
     if PageControl.ActivePage = TabCod then begin // Pgina de cdigo

        if Modified_Cod then // A pgina foi modificada
              Atualiza_Pagina('C', Codigo, ICod)
        else if ICod>=Codigo.Count then Exit;

        Inc(ICod);

        if ICod>=Codigo.Count then ClearGrid(ST_Cod) // Pgina Nova
        else  // Copia pgina sucessiva para a StringGrid
              PaginaToSGrid_Cod(Codigo.Items[ICod]);


        // Atualiza o mostrador do nmero da pgina
        LB_PagCod.Caption := Inttostr(ICod);

        // Atualiza
        Modified_Cod := False;
     end


     else begin// Tratamento de pgina de dados

        if Modified_Dados then // A pgina foi modificada
              Atualiza_Pagina('D', Dados, IDados)
        else if IDados>=Dados.Count then Exit;

        // Aponta para a pgina sucessiva da lista
        Inc(IDados);

        // Pgina Nova
        if IDados>=Dados.Count then ClearGrid(ST_Dados)
        else // Copia pgina sucessiva para a StringGrid
             PaginaToSGrid_Dados(Dados.Items[IDados]);

        // Atualiza o mostrador do nmero da pgina
        LB_PagDados.Caption := Inttostr(IDados);

        // Atualiza
        Modified_Dados := False;
     end

end;





procedure TF_Editor.Atualiza_Pagina(Tipo:char; Lista: Tlist; Indice: word);
var PPagina :TPPagina;

begin
     if Indice>=Lista.Count then begin // A pgina no existia
        new(PPagina); // Cria um novo registro para a pgina
        Lista.Add(PPagina); // Acrescenta pgina  lista
     end
     else PPagina := Lista.Items[Indice];

     // Copia contedo da StringGrid para a pgina na lista
     if Tipo = 'C' // pgina de cdigo
      then SGridToPagina_Cod(PPagina)
      else SGridToPagina_Dados(PPagina);
end;




procedure TF_Editor.SGridToPagina_Cod(PPagina:TPPagina);
var i:byte;
    instr_cod:smallint;
    error:boolean;  // Indica se houve erro na converso
begin
     error:=False;
     for i:=0 to tam_pagina-1 do begin
         if ST_Cod.Cells[0,i]='' then PPagina[i].c1:=0
         else begin
             instr_cod := get_instr_cod(ST_Cod.Cells[0,i]);
             if instr_cod = -1 then Erro ('Instruo invlida na linha '+inttostr(i));
             PPagina[i].c1 := instr_cod;
         end;
         try
            PPagina[i].c2 := strtoint(ST_Cod.Cells[1,i]);
            except on EConvertError do begin
                PPagina[i].c2 := 0;
                error:=True;
            end;
         end;
         try
            PPagina[i].c3 := strtoint(ST_Cod.Cells[2,i]);
            except on EConvertError do begin
                PPagina[i].c3 := 0;
                error:=True;
            end;
         end;
     end;
     if error then ShowMessage('A pgina continha valores numricos invlidos'+#10#13+
                                'que foram convertidos para zero');
end;




procedure TF_Editor.SGridToPagina_Dados(PPagina: TPPagina);
var i:byte;
    error:boolean; // Indica se houve erro na converso
begin
     error:=False;
     for i:=0 to tam_pagina-1 do begin
         try
            PPagina[i].c1 := strtoint(ST_Dados.Cells[0,i]);
            except on EConvertError do begin
                PPagina[i].c1 := 0;
                error:=True;
            end;
         end;
         try
            PPagina[i].c2 := strtoint(ST_Dados.Cells[1,i]);
            except on EConvertError do begin
                PPagina[i].c2 := 0;
                error:=True;
            end;
         end;
         try
            PPagina[i].c3 := strtoint(ST_Dados.Cells[2,i]);
            except on EConvertError do begin
                PPagina[i].c3 := 0;
                error:=True;
            end;
         end;
     end;
     if error then ShowMessage('A pgina continha valores numricos'+#10#13+
                               'invlidos que foram convertidos para zero');

end;





function TF_Editor.get_instr_cod(nome:string):smallint;
var i:byte;
begin
     Result:=-1;
     for i:=0 to num_instr-1 do
        if nome = INSTR[i] then begin
           Result:=i;
           Exit;
        end;
end;




procedure TF_Editor.Erro(mensagem:string);
begin
     raise Exception.Create(mensagem);
end;



procedure TF_Editor.PaginaToSGrid_Cod(Pagina: TPPagina);
var i:byte;
begin
     for i:= 0 to tam_pagina-1 do begin
         ST_Cod.Rows[i].Strings[0] := INSTR[Pagina^[i].c1];
         ST_Cod.Rows[i].Strings[1] := inttostr(Pagina^[i].c2);
         ST_Cod.Rows[i].Strings[2] := inttostr(Pagina^[i].c3);
     end;
end;




procedure TF_Editor.PaginaToSGrid_Dados(Pagina: TPPagina);
var i:byte;
begin
     for i:= 0 to tam_pagina-1 do begin
         ST_Dados.Rows[i].Strings[0] := inttostr(Pagina^[i].c1);
         ST_Dados.Rows[i].Strings[1] := inttostr(Pagina^[i].c2);
         ST_Dados.Rows[i].Strings[2] := inttostr(Pagina^[i].c3);
     end;
end;



procedure TF_Editor.BB_SairClick(Sender: TObject);
begin
    F_Editor.Close;
end;


procedure TF_Editor.BB_NovoClick(Sender: TObject);
begin

  if BB_Salvar.Enabled then
     case MessageDlg('Deseja salvar o job atual?',
          mtConfirmation, [mbYes, mbNo, mbCancel],0) of
         mrYes:begin
            BB_Salvar.Click;
            if BB_Salvar.Enabled then Exit;
         end;
         mrCancel: Exit;
     end;

     // Limpa as listas de pginas de dados e de cdigos
     ClearList(Codigo);
     ClearList(Dados);

     // Limpa os StringGrids de Cdigo e de Dados
     ClearGrid(ST_Cod);
     ClearGrid(ST_Dados);

     Modified_Cod := False;
     Modified_Dados := False;

     // Inicia os ndices das listas de pginas de cdigos e de dados
     IDados := 0;
     ICod := 0;

     LB_PagCod.Caption := Inttostr(ICod);
     LB_PagDados.Caption := Inttostr(IDados);

     // Habilita todos os botoes do formulrio
     Estado_Botoes(True);
     BB_Fechar.Enabled:=True;
end;



procedure TF_Editor.ClearGrid(Grid: TStringGrid);
var i:byte;
begin
    for i:=0 to Grid.RowCount-1 do Grid.Rows[i].Clear;
end;




procedure TF_Editor.ST_CodKeyPress(Sender: TObject; var Key: Char);
begin
   case ST_Cod.Col of
       0: begin
             if key in ['a'..'z'] then begin
                if Length(ST_Cod.Cells[ST_Cod.Col, ST_Cod.Row])=3 then begin
                  Key:=#0;
                  Exit;
                end;
                Key:=Upcase(Key);
                Modified_Cod:=True;
                if not BB_Salvar.Enabled then BB_Salvar.Enabled:=True;
                Exit;
             end;
             if key in ['A'..'Z'] then begin
                if Length(ST_Cod.Cells[ST_Cod.Col, ST_Cod.Row])=3 then begin
                  Key:=#0;
                  Exit;
                end;
                Modified_Cod:=True;
                if not BB_Salvar.Enabled then BB_Salvar.Enabled:=True;
                Exit;
             end;
             if not (Key in [#8, #10]) then Key:=#0;
       end;
       1,2: begin
               if key in ['0'..'9'] then begin
                  if Length(ST_Cod.Cells[ST_Cod.Col, ST_Cod.Row])=4 then begin
                     Key:=#0;
                     Exit;
                  end;
                  Modified_Cod:=True;
                  if not BB_Salvar.Enabled then BB_Salvar.Enabled:=True;
                  Exit;
               end;
             if not (Key in [#8, #10]) then Key:=#0;
       end;
   end;
end;




procedure TF_Editor.ST_DadosKeyPress(Sender: TObject; var Key: Char);
begin
   if key in ['0'..'9', '-'] then begin
     Modified_Dados:=True;
     if not BB_Salvar.Enabled then BB_Salvar.Enabled:=True;
     Exit;
   end;
   if not (Key in [#8, #10]) then Key:=#0;
end;





procedure TF_Editor.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if Key= VK_Next then
       if BB_Pgdw.Enabled then BB_Pgdw.Click;
    if Key= VK_Prior then
       if BB_Pgup.Enabled then BB_Pgup.Click;
end;




procedure TF_Editor.BB_ApagarClick(Sender: TObject);
begin
   if MessageDlg('Voc deseja mesmo apagar a pgina atual?', mtConfirmation, [mbOK, mbCancel],0) = mrCancel then Exit;
   if PageControl.ActivePage = TabCod then begin
      if ICod>=Codigo.Count then ClearGrid(ST_Cod)
      else begin
         Dispose(Codigo.Items[Icod]);
         Codigo.Delete(Icod);
         if (not BB_Salvar.Enabled) then BB_Salvar.Enabled:=True;
         if ICod<Codigo.Count then PaginaToSGrid_Cod(Codigo.Items[Icod])
         else ClearGrid(ST_Cod);
      end;
   end
   else begin
      if IDados>=Dados.Count then ClearGrid(ST_Dados)
      else begin
         Dispose(Dados.Items[IDados]);
         Dados.Delete(IDados);
         if (not BB_Salvar.Enabled) then BB_Salvar.Enabled:=True;
         if IDados<Dados.Count then PaginaToSGrid_Dados(Dados.Items[IDados])
         else ClearGrid(ST_Dados);
      end;
   end;
end;





procedure TF_Editor.BB_SalvarClick(Sender: TObject);
var PPagina:TPPagina;
    Saida:File of TPAgina;
    SaidaTexto:TextFile;
    i,j, Identif, TPrevisto, PagsImpr:integer;
begin

   // Verifica a atualizao das ltimas pginas inseridas
   if Modified_Cod then  Atualiza_Pagina('C', Codigo, ICod);
   if Modified_Dados then Atualiza_Pagina('D', Dados, IDados);


   try
      Identif:=StrToInt(E_Identificador.Text);
      // Gera um valor randomico para o identificador do job
      except on EConvertError do begin
         Identif:=Trunc(Random*5000);
         E_Identificador.Text:=IntToStr(Identif);
      end;
   end;

   try
      TPrevisto:=StrToInt(E_TPrevisto.Text);
      // Gera um valor estatstico para o tempo previsto de execuo do job
      except on EConvertError do begin
        TPrevisto:=Codigo.Count*12;
        E_TPrevisto.Text:=IntToStr(TPrevisto);
      end;
   end;




   if SaveDialog.Execute then begin

      if FileExists(SaveDialog.FileName) then
         if MessageDlg('Este arquivo j existe.'+ #10 +
                        'Deseja sobrescrev-lo?',
                         mtConfirmation, [mbOk, mbCancel],0) = mrCancel then Exit;

      AssignFile(Saida, SaveDialog.FileName);
      Rewrite(Saida);

      // Conta o nmero de comandos PRN para incrementar o nmero de pginas de impresso
      PagsImpr:=0;
      for i:=0 to Codigo.Count-1 do
         for j:=0 to tam_pagina-1 do
             if TPagina(Codigo.Items[i]^)[j].c1=2 then Inc(PagsImpr);


      // Montar pgina inicial
      new(PPagina);
      Zera_Pagina(PPagina);
      PPagina^[0].c1:=1000; PPagina^[0].c2:=1000;  PPagina^[0].c3:=1000;
      PPagina^[1].c1:=Identif;
      PPagina^[2].c1:=TPrevisto;
      PPagina^[3].c1:=Codigo.Count;
      PPagina^[4].c1:=Dados.Count;
      PPagina^[5].c1:=PagsImpr;


      write(Saida, PPagina^);

      // Montar pgina de incio de cdigo
      Zera_Pagina(PPagina);
      PPagina^[0].c1:=2000; PPagina^[0].c2:=2000;  PPagina^[0].c3:=2000;
      write(Saida, PPagina^);

      // Salvar pginas de cdigo
      for i:=0 to Codigo.Count-1 do
           write(Saida, TPAgina(Codigo.Items[i]^));


      // Montar pgina de incio de dados
      Zera_Pagina(PPagina);
      PPagina^[0].c1:=3000; PPagina^[0].c2:=3000;  PPagina^[0].c3:=3000;
      write(Saida, PPagina^);

      // Salvar pginas de dados
      for i:=0 to Dados.Count-1 do
           write(Saida, TPAgina(Dados.Items[i]^));

      // Montar pgina de fim de programa
      Zera_Pagina(PPagina);
      PPagina^[0].c1:=4000; PPagina^[0].c2:=4000;  PPagina^[0].c3:=4000;
      write(Saida, PPagina^);

      // Gera um arquivo txt para o job
      if CheckTXT.Checked then begin
         Reset(Saida);
         AssignFile(SaidaTexto,Copy(SaveDialog.FileName, 0, Length(SaveDialog.FileName)-4)+'.txt');
         Rewrite(SaidaTexto);
         while not eof(Saida) do begin
            read(Saida, PPagina^);
            for i:=0 to tam_pagina-1 do
                writeln(SaidaTexto, PPagina^[i].c1:10, PPagina^[i].c2:10, PPagina^[i].c3:10);
            writeln(SaidaTexto);
         end;
         CloseFile(SaidaTexto);
      end;

      // Fecha o arquivo
      CloseFile(Saida);

      Dispose(PPagina);
      BB_Salvar.Enabled:=False;
   end;
end;





procedure TF_Editor.Zera_Pagina(PPagina: TPPagina);
var i:byte;
begin
    for i:=0 to tam_pagina-1 do begin
        PPagina^[i].c1:=0;
        PPagina^[i].c2:=0;
        PPagina^[i].c3:=0;
    end;
end;





procedure TF_Editor.ClearList(Lista: TList);
var i:integer;
begin
    for i:=0 to Lista.Count-1 do
      Dispose(Lista.Items[i]);
    Lista.Clear;
end;





procedure TF_Editor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     ClearList(Codigo);
     ClearList(Dados);
end;




procedure TF_Editor.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     if BB_Salvar.Enabled then
     case MessageDlg('Deseja salvar o job atual?',
          mtConfirmation, [mbYes, mbNo, mbCancel],0) of
         mrYes:begin
            BB_Salvar.Click;
            if BB_Salvar.Enabled then CanClose:=False;
         end;
         mrCancel: CanClose:=False;
     end;
end;






procedure TF_Editor.ST_CodKeyDown(Sender: TObject; var Key: Word;  Shift: TShiftState);
begin
   if (ssCtrl in Shift) and (Key=VK_Space) and (ST_Cod.Col=0) then begin
      ListCommand.Left:=ST_Cod.Left+Length(ST_Cod.Cells[ST_Cod.Col, ST_Cod.Row])*10+2;
      ListCommand.Top:=ST_Cod.Top+ST_Cod.Row*ST_Cod.DefaultRowHeight+ST_Cod.DefaultRowHeight-6;
      if ListCommand.Top+ListCommand.Height>= TabCod.Height then ListCommand.Top:= ListCommand.Top- ListCommand.Height;
      ListCommand.Show;
      ListCommand.SetFocus;
  end;

end;






procedure TF_Editor.ListCommandKeyDown(Sender: TObject; var Key: Word;  Shift: TShiftState);
begin
 if Key=VK_Return then begin
     ST_cod.Cells[ST_Cod.Col, ST_Cod.Row]:=ListCommand.Items[ListCommand.ItemIndex];
     ListCommand.Hide;
     ST_Cod.SetFocus;
     Modified_Cod:=True;
     if (not BB_Salvar.Enabled) then BB_Salvar.Enabled:=True;
 end
 else if Key=VK_Escape then begin
          ListCommand.Hide;
          ST_Cod.SetFocus;
      end;
end;



procedure TF_Editor.BB_AbrirClick(Sender: TObject);
var PPagina:TPPagina;
    Entrada:File of TPAgina;
    i, NCod, NDados:integer;

begin
     if BB_Salvar.Enabled then
     case MessageDlg('Deseja salvar o job atual?',
          mtConfirmation, [mbYes, mbNo, mbCancel],0) of
         mrYes:begin
            BB_Salvar.Click;
            if BB_Salvar.Enabled then Exit;
         end;
         mrCancel: Exit;
     end;

   if OpenDialog.Execute then begin
      AssignFile(Entrada, OpenDialog.FileName);
      Reset(Entrada);

      new(PPagina);

      ClearList(Codigo);
      ClearList(Dados);

      // L a primeira pgina do JOB
      read(Entrada, PPagina^);

      E_Identificador.Text:=IntToStr(PPagina^[1].c1);
      E_TPrevisto.Text:=IntToStr(PPagina^[2].c1);
      NCod:=PPagina^[3].c1;
      NDados:=PPagina^[4].c1;

      // L a pgina de incio de cdigo
      read(Entrada, PPagina^);
      if (PPagina^[0].c1<>2000) or (PPagina^[0].c2<>2000) or (PPagina^[0].c3<>2000) then
         Erro('Pgina de incio de cdigo invlida no Job');

      // L as pginas de cdigo
      for i:=0 to NCod-1 do begin
         read(Entrada, PPagina^);
         Codigo.Add(PPagina);
         new(PPagina);
      end;

      // L a pgina de incio de dados
      read(Entrada, PPagina^);
      if (PPagina^[0].c1<>3000) or (PPagina^[0].c2<>3000) or (PPagina^[0].c3<>3000) then
         Erro('Pgina de incio de dados invlida no Job');

      // L as pginas de dados
      for i:=0 to NDados-1 do begin
         read(Entrada, PPagina^);
         Dados.Add(PPagina);
         new(PPagina);
      end;


      // L a pgina de fim de Job
      read(Entrada, PPagina^);
      if (PPagina^[0].c1<>4000) or (PPagina^[0].c2<>4000) or (PPagina^[0].c3<>4000) then
         Erro('Pgina de fim de Job invlida');


      // Desaloca a ltima pgina alocada e facha o qrquivo de entrada
      Dispose(PPagina);
      CloseFile(Entrada);

      ICod:=0;
      IDados:=0;

      // Carrega nos StringGrids a primeira pgina de cdigo e de dados
      if Codigo.Count>0 then PaginaToSGrid_Cod(Codigo.Items[0]);
      if Dados.Count>0 then PaginaToSGrid_Dados(Dados.Items[0]);

      // Atualiza os mostradores do nmero da pgina
      LB_Pagcod.Caption := Inttostr(ICod);
      LB_PagDados.Caption := Inttostr(IDados);

      Estado_Botoes(True);
      BB_Fechar.Enabled:=True;

   end;
end;



procedure TF_Editor.E_IdentificadorKeyPress(Sender: TObject; var Key: Char);
begin
   if Key in ['a'..'z', 'A'..'Z'] then Key:=#0
   else if (not BB_Salvar.Enabled) then BB_Salvar.Enabled:=True;
end;




procedure TF_Editor.BB_FecharClick(Sender: TObject);
begin
    if BB_Salvar.Enabled then
     case MessageDlg('Deseja salvar o job atual?',
          mtConfirmation, [mbYes, mbNo, mbCancel],0) of
         mrYes:begin
            BB_Salvar.Click;
            if BB_Salvar.Enabled then Exit;
         end;
         mrCancel: Exit;
     end;

      ClearList(Codigo);
      ClearList(Dados);
      ClearGrid(ST_Cod);
      ClearGrid(ST_Dados);

      // Atualiza os mostradores do nmero da pgina
      LB_Pagcod.Caption := '-';
      LB_PagDados.Caption := '-';
      E_Identificador.Text:='';
      E_TPrevisto.Text:='';

      Estado_Botoes(False);
      BB_Fechar.Enabled:=False;
      BB_Salvar.Enabled:=False;
end;

procedure TF_Editor.Sobre1Click(Sender: TObject);
begin
    F_Sobre.ShowModal;
end;

procedure TF_Editor.CheckTXTClick(Sender: TObject);
begin
   if not BB_Salvar.Enabled then BB_Salvar.Enabled:=True;
end;

procedure TF_Editor.FormDestroy(Sender: TObject);
begin
    ClearList(Codigo);
    ClearList(Dados);
    Codigo.Destroy;
    Dados.Destroy;
end;

end.
