unit HW;
// Definicao das estruturas do hardware virtual utilizado pelo sistema

interface

const
     num_interrupcoes = 14;
     tam_disco = 256;  // Nmero pginas do disco
     tam_pagina = 8;   // Nmero palavras de uma pgina
     num_buffers = 8;  // Nmero mximo de buffers do sistema
     num_instr = 15; // Nmero de instrues de Assembler implementadas em Hardware
     ACC_OVERFLOW =  999999999; //2147483640; // Valor de Overflow do Acumulador



     // Array de instrues
     INSTR: array[0..num_instr-1] of String =
     ('HLT', 'RD', 'PRN', 'LD', 'STR', 'SUB', 'ADD', 'JMP', 'JNG', 'SUI', 'ADI', 'MUL', 'DIV', 'LDI', 'STI');


type

 TPalavra = record
                c1, c2, c3: integer;
            end;


 TPagina = array[0..tam_pagina-1] of Tpalavra;


 TInterrupcao = array[0..num_interrupcoes-1] of boolean;


 // Registrador de comandos (canais)
 TRegistrador_Comandos = record
                             Leitora, Impressora, Disco : boolean;
                         end;

 // Informao de pginas do processo
 TTP = record
     Tam,   // Nmero de pginas de cdigos
     Ras,   // Nmero de pginas de dados
     Pag : integer;  // Endereo da tabela de pginas
 end;


 // Contador de programa (prxima instr.)
 TContador_Programa = record
       Pag, Desl : integer;
 end;

 // Registrador de Instruo
 TRegistrador_Instrucao = record
                               CodOp, Pag, Desl : integer;
                          end;


 // Acumulador
 TACC = integer;



 // Falta de Pgina
 TFalta_Pagina = integer;



 // Timer
 TTimer = integer;



 // Time Slice
 TTime_Slice = integer;



 // Clock
 TClock = Longint;



 // Dispositivo de Entrada
 TEntrada = file of TPagina;



 // Dispositivo de sada
 TSaida = TextFile;



 // Tempo de Canais
 TTempo_Canal = record
                    Leitora, Impressora, Disco : integer;
                end;



 // Memria
 TMemoria = record
     Bitmap: array of byte;
         { Esquema do bitmap:
               0..................Livre
               1......Tabela de pginas
               2.......Pgina de cdigo
               3........Pgina de dados
          }
     Items: array of Tpagina;
     Contador: array of TClock;
 end;


 // Disco
 TDisco = record
        bitmap: array[0..tam_disco-1] of boolean;
        // Se bitmap[i] = True -> pgina Ocupada
       	Items: array[0..tam_disco-1] of Tpagina;
 end;


implementation


end.
