unit Kill;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SO_Unit;

type
  TFKill = class(TForm)
    ListToKill: TListBox;
    BOk: TButton;
    BCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    procedure FormShow(Sender: TObject);
    procedure BOkClick(Sender: TObject);
    procedure BCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    JobKilled:integer;
    Finalizar:boolean;
    function Execute:boolean;
    { Public declarations }
  end;

var
  FKill: TFKill;
  JobsToKill:TList;

implementation

uses MainUnit;

{$R *.DFM}

{ TFKill }


function TFKill.Execute: boolean;
var i, j:integer;
begin
    JobsToKill.Clear;
    ListToKill.Clear;
    // Desaloca filas de estados de BCP's
    for i:=2 to 6 do
       for j:=0 to Estado[i].Count-1 do begin
          JobsToKill.Add(Estado[i].Items[j]);
          ListToKill.Items.Add(IntToStr(pointer_BCP(Estado[i].Items[j]).Job));
       end;

    ShowModal;

    if Finalizar and (ListToKill.Items.Count>0) then begin
       ProcessoMorto:=JobsToKill.Items[FKill.JobKilled];
       Fmain.VInter[3]:=True;
       Trata_Interrupcao;
       Result:=True;
    end
    else Result:=False;


end;


procedure TFKill.FormShow(Sender: TObject);
begin
  Finalizar:=False;
end;

procedure TFKill.BOkClick(Sender: TObject);
begin
  JobKilled:=ListToKill.ItemIndex;
  Finalizar:=True;
  Close;
end;

procedure TFKill.BCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFKill.FormCreate(Sender: TObject);
begin
   JobsToKill:=TList.Create;
end;

procedure TFKill.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   ShowKill:=False;
end;

end.
